<?php

if( !function_exists( 'sm_dropcap_func' ) ) {
	function sm_dropcap_func( $atts, $content = null ) {
		extract ( shortcode_atts ( array (
			'color' => '',
			'style' => 'regular-text', 
		), $atts ) );

		$style = sm_validate_with_array( $style, sm_get_dropcap_styles_array() );

		$custom_css = '';
		if ( !empty( $color ) ) {
			if ( substr( $style, -4 ) == 'text' ) 
				$custom_css = 'color:' . $color . ';';
			else
				$custom_css = 'background-color:' . $color . ';';
		}
		if ( '' != $custom_css ) $custom_css = ' style="' . $custom_css . '"';

		$output = '';
		$output .= '<span class="sm-dropcap ' . $style . '"' . $custom_css . '>';
		$output .= do_shortcode( $content );
		$output .= '</span>';
		return $output;
	}
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Dropcap', 'semona-extension' ),
	'base' => 'sm_dropcap',
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-dropcap.png',
	'params' => array(
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Color', 'semona-extension' ),
			'param_name' => 'color',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'semona-extension' ),
			'param_name' => 'style',
			'value' => sm_get_dropcap_styles_array(),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Letter', 'semona-extension' ),
			'param_name' => 'content',
		)
	)
) );